
package Alkindi.Services.ServicesImpl;

import java.util.*;
import java.sql.*;
import javax.ejb.*;
import javax.transaction.*;
import oracle.jdbc.driver.*;
import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.Util.*;
import Alkindi.Services.InternalData.*;
import java.rmi.RemoteException;

/* 
$Header: RatingManager.java, 49, 5/11/01 11:07:34 AM, Schwartz, Joe$
$Log: 
 49   Alkindi Development1.48        5/11/01 11:07:34 AM  Schwartz, Joe  
      Cleaned up logging.
 48   Alkindi Development1.47        5/8/01 10:08:21 AM   Schwartz, Joe  
      Changed references to UserEvalInfo to new UserEvalStats class in
      InternalData package. Changed method RatMgrDBUtils.getUserEvalInfo() to
      getUserEvalStats().
 47   Alkindi Development1.46        5/8/01 9:57:53 AM    Schwartz, Joe  
      Changed to use nested class of RatMgrDBUtils UserEvalInfo to deal with
      stats necesssary for selecting products to rate. Changed use of
      InternalEJBManager to InternalComponentManager. Removed dependencies on
      EJB from these classes. Cleaned up comments.
 46   Alkindi Development1.45        4/26/01 2:37:16 PM   Schwartz, Joe  
      Modifed to account for new InternalData package.
 45   Alkindi Development1.44        4/26/01 1:11:14 PM   Schwartz, Joe   Moved
      into new ServicesImpl package.
 44   Alkindi Development1.43        4/26/01 11:18:30 AM  Schwartz, Joe  
      Changed to account for connection being set to autocommit; removed several
      calls to con.commit().
 43   Alkindi Development1.42        3/14/01 5:50:43 PM   Schwartz, Joe   Made
      the rest of these implementation classes abstract.
 42   Alkindi Development1.41        3/14/01 5:48:06 PM   Schwartz, Joe   Got
      rid of sessCtx member & changed to use conneciton's commit() method.
 41   Alkindi Development1.40        2/23/01 4:33:24 PM   Schwartz, Joe   Small
      fixes accomodating new integer product ID.
 40   Alkindi Development1.39        2/22/01 3:16:58 PM   Schwartz, Joe  
      Changesto facilitate new floating--point evaluations. 
 39   Alkindi Development1.38        2/13/01 5:55:30 PM   Schwartz, Joe  
      Changed to account for new Product id int type and SparseRatingsArray.
 38   Alkindi Development1.37        2/5/01 3:08:22 PM    Schwartz, Joe  
      Changed to accomodate new AlkConn members.
 37   Alkindi Development1.36        1/25/01 9:58:06 PM   Schwartz, Joe  
      Working on speed, sensibility.
 36   Alkindi Development1.35        1/2/01 11:59:21 AM   Schwartz, Joe   Fixed
      error in ProductSelector.selectOldProduct() - was using
      newProdPopularWeights by mistake. Changed some init() function names.
 35   Alkindi Development1.34        12/29/00 1:14:57 PM  Schwartz, Joe   Added
      dependency on UserStat for the getNumProdSeen method.
 34   Alkindi Development1.33        12/28/00 2:50:40 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 33   Alkindi Development1.32        12/28/00 1:09:51 PM  Schwartz, Joe   Added
      Version Control header info.
      Synchronized with IRatingManager interface.
      Changed package-scope members to protected.
 32   Alkindi Development1.31        12/28/00 12:05:51 PM Schwartz, Joe   
 31   Alkindi Development1.30        12/27/00 6:10:12 PM  Schwartz, Joe   
 30   Alkindi Development1.29        12/26/00 6:57:15 PM  Schwartz, Joe   
 29   Alkindi Development1.28        12/26/00 5:36:59 PM  Schwartz, Joe   
 28   Alkindi Development1.27        12/20/00 8:18:20 PM  Schwartz, Joe   
 27   Alkindi Development1.26        12/20/00 5:44:54 PM  Schwartz, Joe   
 26   Alkindi Development1.25        12/19/00 3:51:58 PM  Schwartz, Joe   
 25   Alkindi Development1.24        12/18/00 6:08:24 PM  Schwartz, Joe   
 24   Alkindi Development1.23        12/18/00 12:05:39 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 23   Alkindi Development1.22        12/18/00 11:22:09 AM Schwartz, Joe   
 22   Alkindi Development1.21        12/10/00 3:30:04 PM  Schwartz, Joe  
      Corrected passing AlkExcept back up stack in getProductsToRate.
 21   Alkindi Development1.20        12/7/00 10:55:39 AM  Schwartz, Joe  
      Reduced debug log notifications.
 20   Alkindi Development1.19        12/6/00 7:11:58 PM   Schwartz, Joe   Added
      catch blocks for generic exceptions and finally blocks to close all
      database connections.
 19   Alkindi Development1.18        12/4/00 12:02:46 PM  Schwartz, Joe  
      Addional connection.close() statements.
 18   Alkindi Development1.17        12/3/00 10:40:17 PM  Schwartz, Joe   
 17   Alkindi Development1.16        11/30/00 12:46:42 AM Schwartz, Joe   
 16   Alkindi Development1.15        11/29/00 5:00:43 PM  Schwartz, Joe   Major
      clean up of getProductsToRate.
 15   Alkindi Development1.14        11/27/00 7:40:14 PM  Schwartz, Joe   
 14   Alkindi Development1.13        11/21/00 4:17:47 PM  Schwartz, Joe   
 13   Alkindi Development1.12        11/20/00 10:52:34 PM Schwartz, Joe   
 12   Alkindi Development1.11        11/14/00 12:53:14 PM Schwartz, Joe   
 11   Alkindi Development1.10        11/8/00 2:59:02 PM   Schwartz, Joe   
 10   Alkindi Development1.9         11/3/00 1:29:57 PM   Schwartz, Joe   
 9    Alkindi Development1.8         11/2/00 6:31:54 PM   Schwartz, Joe   
 8    Alkindi Development1.7         10/25/00 3:13:40 PM  Schwartz, Joe   
 7    Alkindi Development1.6         10/24/00 12:29:45 PM Schwartz, Joe  
      Started cleaning up getProductsToRate().
 6    Alkindi Development1.5         10/23/00 12:14:57 PM Schwartz, Joe   v0.42
      update - fixes repeat products in getProductsToRate.
 5    Alkindi Development1.4         10/22/00 10:38:45 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 4    Alkindi Development1.3         10/20/00 12:00:44 PM Schwartz, Joe   
 3    Alkindi Development1.2         10/17/00 2:22:57 PM  Schwartz, Joe  
      Delivery 10.16.00
 2    Alkindi Development1.1         10/7/00 4:34:33 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/7/00 4:26:03 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public abstract class RatingManager implements IRatingManager 
{
	
	/**
	 * Coefficient a in equation used to determine whether to use User or Product data to get a Product to rate.
	 */
	protected static double propa;
	protected static double propA;
	
	/**
	 * Coefficient b in equation used to determine whether to use User or Product data to get a Product to rate.
	 */
	protected static double propb;
	protected static double propB;
	protected static double propC;
	protected static int propDelta;
	protected static int propGamma;
	protected static double propI;
	protected static double propJ;
	protected static double propK1;
	protected static double propK2;
	protected static double propKappa;
	
	/**
	 * 	Number of Product Clusters (an Engine property).
	 */
	protected static int propNumPCs;
	protected static int propOmega;
	protected static double propS1;
	protected static double propS2;
	protected static double propU;
	protected static double propV;
	protected static double propW;
	protected static double propZ;
	final String cName = "RatingManager";
	LogManager logger = null;
	RatingMgrDBUtils rmdb;
	
	/**
	 * 	@return void
	 * @roseuid 3A4B660F0012
	 */
	public void readProps() 
	{
		final String mName = "readProps";
		try {
			propNumPCs = PropertyManager.getInt("NumPC");
			propa = PropertyManager.getDouble("a");
			propb = PropertyManager.getDouble("b");
			propA = PropertyManager.getDouble("A");
			propB = PropertyManager.getDouble("B");
			propC = PropertyManager.getDouble("C");
			propI = PropertyManager.getDouble("I");
			propJ = PropertyManager.getDouble("J");
			propK1 = PropertyManager.getDouble("K1");
			propK2 = PropertyManager.getDouble("K2");
			propS1 = PropertyManager.getDouble("S1");
			propS2 = PropertyManager.getDouble("S2");
			propU = PropertyManager.getDouble("U");
			propV = PropertyManager.getDouble("V");
			propW = PropertyManager.getDouble("W");
			propZ = PropertyManager.getDouble("Z");
			propDelta = PropertyManager.getInt("Delta");
			propGamma = PropertyManager.getInt("Gamma");
			propKappa = PropertyManager.getDouble("Kappa");
			propOmega = PropertyManager.getInt("Omega");
			
			rmdb = new RatingMgrDBUtils();
		}
		catch(Exception e) {
			//logger.err(cName, mName, e.getMessage());
			System.out.println("ERROR in " + cName + "." + mName + ": " + e.getMessage());
			//e.printStackTrace();
		}
	}
	
	/**
	 * 	@return void
	 * @roseuid 3A4B660F001F
	 */
	public void initLogging() 
	{
		if (logger == null) 
			logger = new LogManager();
	}
	
	/**
	 * 		Submits a RatingList to the database.
	 * 		@param rl the RatingList to store.
	 * 		@return void
	 * 		@throws AlkExcept
	 * @roseuid 3A4B660F002E
	 */
	public void rateProducts(final Alkindi.Data.RatingList rl) throws AlkExcept,RemoteException 
	{
		final String mName = "rateProducts";
		String errmsg = "";

		int counter;
		int numReturn;
		Connection con = null;

		try{
			con = AlkConn.getConnection();
			CallableStatement cs = con.prepareCall("{ call pkg_ALKINDI_EVALUATION.sp_INSERT_Evals(?,?,?)}");

			for(counter = 0; counter < rl.size(); counter++) {
				cs.setLong(1,(rl.get(counter)).user.id);
				cs.setLong(2,(rl.get(counter)).prod.id);
				cs.setFloat(3,(rl.get(counter)).evaluation);
				cs.executeUpdate();
			}
			cs.close();
		}
		catch(SQLException se) {
			errmsg = "Error in Stored Procedure pkg_ALKINDI_EVALUATION.sp_INSERT_Evals: " + se.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 6004);
		}
		catch(Exception e) {
			errmsg = "Unexpected error: " + e.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 2302);
		}
		finally {
			try {
				con.close(); 
			}
			catch (Exception e){
			}
		}
	}
	
	/**
	 * Retrieves a user's ratings from the database. Simply calls RatingMgrDBUtils.getUserRatings().
	 * @param user the user in question.
	 * @return RatingList
	 * @throws AlkExcept
	 * @roseuid 3A4B660F005D
	 */
	public Alkindi.Data.RatingList getUserRatings(Alkindi.Data.SystemUser user) throws AlkExcept 
	{
		final String mName = "getUserRatings";

		try {
			return rmdb.getUserRatings(user);
		}
		catch(AlkExcept ae) {
			logger.err(cName, mName, ae.toString());
		}
		return null;
	}
	
	/**
	 * 		Retrieves the a given number of products to rate for a given user.
	 * 		@param user the SystemUser in question.
	 * 		@param numDesired the number of products to retrieve for rating.
	 * 		@return ProductList
	 * 		@throws AlkExcept
	 * @roseuid 3A4B660F007D
	 */
	public Alkindi.Data.ProductList getProductsToRate(final Alkindi.Data.SystemUser user, final int numDesired) throws AlkExcept 
	{
		 final String mName = "getProductsToRate";
		 final int FAULT_LIMIT=20;	//	# times the getProduct routines can return 0 or something we already have.
		 try  {

				ProductList pl = new ProductList();
								
				//	Weight used to decide whether to use User or Product stats 
				//
				IRecommendationManager recMgr = InternalComponentManager.getRecMgr();
				double akx = recMgr.getAlkindex(user);
				InternalComponentManager.remove(recMgr);
				//logger.dbgLog(cName, mName, "user = " + user.id);
				//logger.dbgLog(cName, mName, "rmdb = " + rmdb);
				UserEvalStats ues = rmdb.getUserEvalStats(user);
				logger.dbgLog(cName, mName, ues.toString());
				double Wm = 0;
				if ((ues.coreShown/ues.totalCore) >= (propS1 - (propK1 * akx))){
					Wm = propa + (propb - propa)*akx;
				}
								
				int j = 0;
				ArrayList Vpl = new ArrayList();

				//	Weights to help choose between new and existing product data.
				//	Used only when the user ID != 0.
				//
				double We = 0;
				double epsilonPrime = 0;
				if ((ues.coreShown + ues.selectableShown) > 0) {
					epsilonPrime = ues.epsilonUser - ues.epsilonEveryone;
				}
				
				if ((ues.selectableShown/ues.totalSelectable) >= (propS2 -(propK2 * akx))) {
					if (epsilonPrime > 0){
						We = propJ - (propJ - propI)*Math.exp((-1)*propZ*UserStat.getNumProdSeen(user));
					}
					else {
						We = propI;
					}
				}

				logger.dbgLog(cName, mName, "We=" + We);
				logger.dbgLog(cName, mName, "Wm=" + Wm);

				//	Fault counter. This is used to decide when to force the system to use
				//	User Data to get products to rate.
				//
				int getProductFaultCount = 0;
				logger.dbgLog (cName, mName, "Attempting to get " + numDesired + " products to rate");
				ProductSelector prodSelector = new ProductSelector();

				while (pl.size() < numDesired) {

					//	Flag for main choice in getting products to rate.
					//
					int useUserData = 1;

					//	If get_movie_data returns nothing too many times, force out of
					//	the selectProductByUserData routine
					//
					if (getProductFaultCount > FAULT_LIMIT)
						useUserData = 0;
					else {
						//	If the user has rated less than a certain number of movies,
						//	use getUserData. Othewise, use weighted random.
						//
						if (user.id > 0) {
							RatingList rl = getUserRatings(user);
							if (rl != null) {
								//	Eventually the threshold will be determined by T1, K1
								//	and the Alkindex.
								//
								if (rl.size() > propS1)  {
									useUserData = RandomStick.chooseBinary(Wm);  // Chooses 1 or 0 based on random space determined by Wm
								}
							}
						}
					}

					int prodID = 0;
					//	Get a productID using user data
					//
					if ((useUserData == 1)){ 
						prodID = prodSelector.selectProductByUserData(user, Vpl);
						logger.dbgLog(cName, mName, "User Data provided product ID " + prodID);
					}
					else {
						//	Get product to rate using Product Data instead.
						//	The choice is now between "old" and "new" products.
						//	We choose using weights from the database...
						//	unless the fault count forces us to use existing products.
						//
						int useNewProductData = 0;
						if (getProductFaultCount > FAULT_LIMIT)
							useNewProductData = 0;
						else
							useNewProductData = RandomStick.chooseBinary(We); // Chooses 1 or 0 based on random space determined by We

						if (useNewProductData == 1) {
							prodID = prodSelector.selectNewProduct(user,Vpl);
							logger.dbgLog(cName, mName, "Got product ID using New Product Data:" + prodID);
						}
						else {
							prodID = prodSelector.selectOldProduct(user, Vpl);
							//logger.dbgLog(cName, mName, "Got product ID using Old Product Data:" + prodID);
						}
					}
					//	See if we can add the product to the list. Is it zero?
					//	Is it already in the list?
					//
					boolean addIt = true;
					for (int plIdx = 0; plIdx < pl.size(); plIdx ++ ) {
						if (pl.get(plIdx).id == prodID) {
							addIt = false;
							break;
						}
					}
					//logger.dbgLog(cName, mName, "PL contains = " + (!addIt) + " for pid = " + prodID);
					if (prodID == 0) {
						getProductFaultCount ++;
						addIt = false;
					}
					//	Add the product to the returnable list if all is OK
					//
					if (addIt) {
						pl.add(new Product(prodID));
						Vpl.add(new Long(prodID));
					}
					//	Exit while
					if (getProductFaultCount > 2000) {
						logger.dbgLog(cName, mName, "Fault limit reached. Exiting while() loop.");
						break;
					}
				} // else
			return pl;
		 }
		 catch (AlkExcept ae) {
			 ae.printStackTrace();
			 logger.err(cName, mName, ae.toString());
			 throw ae;
		 }
		 catch(Exception e) {
			AlkExcept ae = new AlkExcept("Unexpected error in " + mName, 2201, e);
			logger.err(cName, mName, ae.toString());
			throw ae;
		 }
	}
	
	/**
	 * @roseuid 3A4B660F00CB
	 */
	public Alkindi.Data.ProductList getInitialProductsToRate(final int numDesired) throws AlkExcept 
	{
		SystemUser nullUser = new SystemUser(0);
		return getProductsToRate(nullUser, numDesired);
	}
	
	/**
	 * Nested class to assist in selecting Products to present for rating.
	 */
	public class ProductSelector 
	{
		
		/**
		 * ProductCluster weights to use when using User Data
		 */
		private double userDataPCWeights[] = null;
		
		/**
		 * ProductCluster weights to use when using Old Products
		 */
		private double oldProdPCWeights[] = null;
		
		/**
		 * Array of Popular/Unpopular weightings to use when selecting an Old Product
		 */
		private double oldProdPopularWeights[] = null;
		
		/**
		 * ProductCluster weights to use when using New Products
		 */
		private double newProdPCWeights[] = null;
		
		/**
		 * Array of Popular/Unpopular weightings to use when selecting an New Product
		 */
		private double newProdPopularWeights[] = null;
		
		/**
		 * Default Constructor. Initializes the ProductCluster weight arrays.
		 * @roseuid 3A4B660F010B
		 */
		public ProductSelector() 
		{
		}
		
		/**
		 * 		Intializes the array of ProductCluster weights to use when selected a product using User data.
		 * 		@param user The SystemUser for whom the weights are calculated.
		 * 		@return void
		 * 		@throws AlkExcept
		 * @roseuid 3A4B660F010C
		 */
		private void initUserDataWeights(SystemUser user) throws AlkExcept 
		{
			userDataPCWeights = new double[propNumPCs];
			HashMap udMap = rmdb.getUserPCData(user);		
			//	If the user has no useful evaluation data, then
			//	there will be no entries in the list returned by 
			//	rmdb.getUserPCData. User null user to get ratings and
			//	set flag to use appropriate weights.
			//		 
			boolean userNullUserWeights = false;
			if (udMap.size() > 0) {
				for (int j = 0; j < propNumPCs; j++){
					ProductCluster pc = new ProductCluster(j+1);
					PCRatDataByUser ud = (PCRatDataByUser)udMap.get(pc);
		//			System.out.println("Getting UD for pc + " + pc.id + " ...hash=" + pc.hashCode());
					if (null == ud) throw new AlkExcept("getUserData: ud is null for pcid" + (j+1), 2304);
		//				logger.dbgLog("GetMovie", "get_user_data", "Using null user weights.");
					userDataPCWeights[j] = ud.calcWeight(propA, propB, propC);
		//				logger.dbgLog("GetMovie", "get_user_data", "Calculated weights for product clusters.");
					
				}// for
			}
			else {
			}
		}
		
		/**
		 * 		Intializes the array of ProductCluster weights to use when selected a New Product.
		 * 		@param user The SystemUser for whom the weights are being retrieved.
		 * 		@return void
		 * 		@throws AlkExcept
		 * @roseuid 3A4B660F010E
		 */
		private void initNewProdWeights(SystemUser user) throws AlkExcept 
		{
			newProdPCWeights = new double[propNumPCs];
			newProdPopularWeights = new double[propNumPCs];
			HashMap newPDMap = rmdb.getNewProdPCData(user);
			for (int j = 0; j < propNumPCs; j++){
				PCRatDataByProd newPD = (PCRatDataByProd)newPDMap.get(new ProductCluster(j+1));
				if (null == newPD) {
					throw new AlkExcept("initNewProdWeights: newPD is null for j=" + j, 2305);
				}
				newProdPCWeights[j] = newPD.calcWeight(0.0, propB);
				newProdPopularWeights[j] = propV - (propV - propU)*(Math.exp((-1)*propW*newPD.E()));
			}// for
		}
		
		/**
		 * 		Intializes the array of ProductCluster weights to use when selected an Old Product.
		 * 		@param user The SystemUser for whom the weights are being retrieved.
		 * 		@return void
		 * 		@throws AlkExcept
		 * @roseuid 3A4B660F0110
		 */
		private void initOldProdWeights(SystemUser user) throws AlkExcept 
		{
			oldProdPCWeights = new double[propNumPCs];
			oldProdPopularWeights = new double[propNumPCs];
			HashMap oldPDMap = rmdb.getOldProdPCData(user);
			for (int j = 0; j < propNumPCs; j++){
				PCRatDataByProd oldPD = (PCRatDataByProd)oldPDMap.get(new ProductCluster(j+1));
				if (null == oldPD) {
					throw new AlkExcept("initOldProdWeights: oldPD is null for j=" + j, 2305);
				}
				oldProdPCWeights[j] = oldPD.calcWeight(0.0, propB);
				oldProdPopularWeights[j] = propV - (propV - propU)*(Math.exp((-1)*propW*oldPD.E()));
			}// for
		}
		
		/**
		 * 			Selects a product to rate based on the "User Data" for the given user. What does this really mean? See the spec...
		 * 			@param user the user for whom to select a product to rate.
		 * 			@param selectedProducts a list of products already selected
		 * 			@return long
		 * 			@throws AlkExcept
		 * @roseuid 3A4B660F011A
		 */
		public int selectProductByUserData(SystemUser user, ArrayList selectedProducts) throws AlkExcept 
		{
			final String mName = "selectProductByUserData";
			int pidToRate =0;
			//	Initialize PC weights on demand
			//
			if (userDataPCWeights == null) {
				initUserDataWeights(user);
			}
			
			int selectedPC = RandomStick.chooseByWeights(userDataPCWeights) + 1;
			ArrayList prodList = rmdb.getUserProdData(user, selectedPC);
			int i = 0;
			//logger.dbgLog("GetMovie", "get_user_data", "GUD2 returned " + Vgud2.size() + " items for pcid=" + selectedPC);
	/*		logger.dbgLog(cName, mName, "Weights:");
			String dbgWts + "";
			for (int idx = 0; idx < propNumPCs; idx ++) {
				dbgWts += "  " + w[idx]);
			}
			logger.dbgLog("GetMovie", "get_user_data", dbgWts);
	*/		
			while (i < (prodList.size())){
				Integer pidLong = (Integer)prodList.get(i);
				if (!selectedProducts.contains(pidLong)) {
					pidToRate = pidLong.intValue();
					break;
				}
				i++;
			}
			return pidToRate;
		}
		
		/**
		 * 			Selects a new Product for the given user to rate.
		 * 			@param user the user for whom to retrieve a new product.
		 * 			@param selectedProducts	an ArrayList of products already selected to present for rating.
		 * 			@return long
		 * 			@throws AlkExcept
		 * @roseuid 3A4B660F011D
		 */
		public int selectNewProduct(SystemUser user, ArrayList selectedProducts) throws AlkExcept 
		{
			//	Initialize PC weights on demand
			//
			if (newProdPCWeights == null) {
				initNewProdWeights(user);
			}
			int pidToRate = 0;
	
			int selectedPC = RandomStick.chooseByWeights(newProdPCWeights) + 1;
			Random rndGen = new Random();
					
			int k = RandomStick.chooseBinary(newProdPopularWeights[selectedPC-1]);
			boolean doLoop = true;	
			//System.out.println("get_new_movie_data: selected PC=" + selectedPC);
			//System.out.println("get_new_movie_data: Vgnmd2 size = " + Vgnmd2.size());
			//System.out.println("get_new_movie_data: Vgnmd3 size = " + Vgnmd3.size());
			//if k=1 choose from the popularlist else choose from unpopularlist
			//
			if (k == 1){
				ArrayList pidList = rmdb.getNewProdPopular(user, selectedPC);
				while ((doLoop == true) && (pidList.size() > 0)){
					int idx = rndGen.nextInt(pidList.size());
	//				System.out.println("get_new_movie_data: Attempting to get Vgnmd2 element " + d);
					Integer pidItem = (Integer)pidList.get(idx);
					doLoop = selectedProducts.contains(pidItem);
					if (doLoop) 
						pidList.remove(pidItem); 
					else
						pidToRate = pidItem.intValue();
				}
			} //if
			
			else{
				ArrayList pidList = rmdb.getNewProdObscure(user, selectedPC);
				while ((doLoop == true) && (pidList.size() > 0)){
					int idx = rndGen.nextInt(pidList.size());
					//System.out.println("get_new_movie_data: Attempting to get Vgnmd3 element " + d);
					Integer pidItem = (Integer)pidList.get(idx);
					doLoop = selectedProducts.contains(pidItem);
					if (doLoop) 
						pidList.remove(pidItem);
					else
						pidToRate = pidItem.intValue();
				}
			} //else
			return pidToRate;
		}
		
		/**
		 * 			Selects an old Product for the given user to rate.
		 * 			@param user	the user for whom products to ratie are being selected.
		 * 			@param selectedProds an ArrayList of the products already selected.
		 * 			@return long
		 * 			@throws AlkExcept
		 * @roseuid 3A4B660F0120
		 */
		public int selectOldProduct(SystemUser user, ArrayList selectedProducts) throws AlkExcept 
		{
			if (oldProdPCWeights == null) 
				initOldProdWeights(user);
				
			int pidToRate = 0;
			
			int selectedPC = RandomStick.chooseByWeights(oldProdPCWeights) + 1;
			int delta1 = propDelta + 1;
/*			ArrayList oldProds = rmdb.getOldProdByPC(user, selectedPC);
			boolean keepLooking = true;
			Long item = new Long(0);
			while (oldProds.size() > 0 && keepLooking) {
				item = (Long)oldProds.get(0);
				keepLooking = selectedProducts.contains(item);
				oldProds.remove(item);
			}
			if (keepLooking)
				return 0;
			else
				return item.longValue();*/

			boolean doLoop = true;
			Random rndGen = new Random();
	
			int k = RandomStick.chooseBinary(oldProdPopularWeights[selectedPC-1]);
			if (k == 1){
				ArrayList pidList = rmdb.getOldProdPopular(user, selectedPC, propOmega, propDelta);
				while ((doLoop == true) && (pidList.size() > 0)){
					int idx = rndGen.nextInt(pidList.size());
	//				System.out.println("getOldProduct: Attempting to get Vgnmd2 element " + d) ;
					Integer pidItem = (Integer)pidList.get(idx);
					doLoop = selectedProducts.contains(pidItem);
					if (doLoop) 
						pidList.remove(pidItem); 
					else
						pidToRate = pidItem.intValue();
				}
			} //if
			
			else{
				ArrayList pidList = rmdb.getOldProdObscure(user, selectedPC, propOmega, propDelta);
				while ((doLoop == true) && (pidList.size() > 0)){
					int idx = rndGen.nextInt(pidList.size());
					//System.out.println("getOldProduct: Attempting to get Vgnmd3 element " + d);
					Integer pidItem = (Integer)pidList.get(idx);
					doLoop = selectedProducts.contains(pidItem);
					if (doLoop) 
						pidList.remove(pidItem);
					else
						pidToRate = pidItem.intValue();
				}
			} //else
			return pidToRate;
		}
	}
}
